/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org2.eclipse.php.internal.ui.util.PixelConverter;

public class SWTFactory {
    public static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = SWTFactory.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        SWTFactory.setButtonDimensionHint(button);
        return button;
    }

    public static Label createLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 0);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        gd.grabExcessHorizontalSpace = false;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Label createWrapLabel(Composite parent, String text, int hspan) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        l.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = hspan;
        l.setLayoutData((Object)gd);
        return l;
    }

    public static Composite createComposite(Composite parent, int columns, int hspan, int fill) {
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(columns, false));
        g.setFont(parent.getFont());
        GridData gd = new GridData(fill);
        gd.horizontalSpan = hspan;
        g.setLayoutData((Object)gd);
        return g;
    }
}

